<?php
/**
 * Created by vm.pl
 * User: Rafał Ignaszewski (rafal@vm.pl)
 * Date: 03.12.13 12:44
 */

namespace VM\ApiBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use VM\ApiBundle\Entity\Service;

class LoadServicesData extends AbstractFixture implements OrderedFixtureInterface
{
    protected $applications = array(
        array('name' => 'Serwis testowy', 'key' => 'sHug4572RABbO7T6k7zHeQ6oWouCk3', 'methods' => array(
            'user_login',
            'user_check_token',
            'user_register',
            'user_registration_confirm',
            'user_update',
            'user_generate_password_recovery_token',
            'user_change_password',
            'user_get',
            'user_get_names',
            'user_get_roles',
            'user_set_roles',
            'user_app_update',
            'user_app_delete',
            'user_logout',
        )),
        array('name' => 'j-apps', 'key' => 'slaprovufrc5oNOUNScNruphivabri', 'methods' => array(
            'user_login',
            'user_check_token',
            'user_register',
            'user_logout'
        )),
        array('name' => 'flash-apps', 'key' => 'Z2aGiT7WV3tostuvuvopr5iYiY0VKO', 'methods' => array(
            'user_login',
            'user_check_token',
            'user_register',
            'user_update',
            'user_logout'
        )),
    );


    /**
     * {@inheritDoc}
     */
    public function load(ObjectManager $Manager)
    {
        foreach($this->applications as $appData)
        {
            $Service = new Service();
            $Service->setName($appData['name']);
            $Service->setAppKey($appData['key']);
            $Manager->persist($Service);
            foreach($appData['methods'] as $methodName)
            {
                $Method = $this->getReference($methodName);
                $Service->addMethod($Method);
                $Method->addService($Service);
            }


        }



        $Manager->flush();
    }

    /**
     * {@inheritDoc}
     */
    public function getOrder()
    {
        return 10;
    }
}